#ifndef __Basics__
#define __Basics__

/**
 * @file Basics.h
 * @brief Single include for the basics package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Basics.h,v 1.3 2007/02/08 21:06:44 paul Exp $
 */


/**
 * @namespace Exponent::Basics
 * @brief Basic component level namespace
 *
 * Contains all the low level stuff such as class management, strings and built in objects
 */

#include "StdDefines.h"
#include "StdIncludes.h"
#include "CBool.hpp"
#include "CCountedObject.hpp"
#include "CDouble.hpp"
#include "CFloat.hpp"
#include "CHtmlString.hpp"
#include "CLong.hpp"
#include "CPascalString.hpp"
#include "CString.hpp"
#include "CSystemString.hpp"
#include "CStringTokeniser.hpp"
#include "ICountedObject.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::Basics;
#endif

#endif	// End of Basics.h